<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Presentation.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$presentation = new Presentation($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$presentation->presentation_id = $data->presentation_id;
$presentation->pres_file_path = $data->pres_file_path;
$presentation->company_id = $data->company_id;

if(check_auth()){
    // Create
    if ($presentation->update()) {
        echo json_encode(
            array("message" => "presentation updated")
        );
    } else {
        echo json_encode(
            array("message" => "presentation not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update presentation."
        )
    );
}