<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Phonebook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init phonebook object
$phonebook = new Phonebook($db);
$phonebook->phonebook_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$phonebook->read_single();


// phonebook array
$phonebook_arr = array(
    "phonebook_id" => $phonebook->phonebook_id,
    "pb_name" => $phonebook->pb_name,
    "pb_number" => $phonebook->pb_number,
    "user_id" => $phonebook->user_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($phonebook_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read phonebook contact."
        )
    );
}