<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Phonebook.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init phonebook object
$phonebook = new Phonebook($db);

// Store read method result in variable & count rows
$result = $phonebook->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // phonebook array
        $phonebook_arr = array();
        $phonebook_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each phonebook will look like this
            $phonebook = array(
                'phonebook_id' => $phonebook_id,
                'pb_name' => $pb_name,
                'pb_number' => $pb_number,
                'user_id' => $user_id
            );

            // Push to "Data"
            array_push($phonebook_arr["data"], $phonebook);
        }
        // Convert result to JSON
        echo json_encode($phonebook_arr);
    } else {
        // No phonebook returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No phonebook contacts found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read phonebook contacts."
        )
    );
}





