<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Phonebook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();
$db->query("SET foreign_key_checks = 0");
// Init phonebook object
$phonebook = new Phonebook($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$phonebook->pb_name = $data->pb_name;
$phonebook->pb_number = $data->pb_number;
$phonebook->company_id = $data->company_id;

if(!check_auth()){
    // Create
    if ($phonebook->create()) {
        echo json_encode(
            array(
                "status" => 200,
                "message" => "phonebook contact created"
                )
        );
    } else {
        echo json_encode(
            array(
                "message" => "phonebook contact not created"
                )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create phonebook contact."
        )
    );
}