<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Location.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init location object
$location = new Location($db);
$location->location_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$location->read_single();

// location array
$location_arr = array(
    "location_id" => $location->location_id,
    "location_name" => $location->location_name,
    "company_id" => $location->company_id,
    "active" => $location->active
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($location_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read location."
        )
    );
}