<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Location.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init location object
$location = new Location($db);
$location->company_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$location_names = $location->readLocationByCompanyId();

// location array
$location_arr = array(
    "location_names" => $location_names
);

if(check_auth()){
    // Convert result to JSON
    echo json_encode($location_arr);
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read location by company id."
        )
    );
}