<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Location.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init location object
$location = new Location($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$location->location_name = $data->location_name;
$location->company_id = $data->company_id;

if(check_auth()){
    // Create location
    if ($location->create()) {
        echo json_encode(
            array("message" => "location created")
        );
    } else {
        echo json_encode(
            array("message" => "location not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create location."
        )
    );
}