<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/LocationEvent.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init locationEvent object
$locationEvent = new LocationEvent($db);
$locationEvent->location_events_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$locationEvent->read_single();

// locationEvent array
$locationEvent_arr = array(
    "location_events_id" => $locationEvent->location_events_id,
    "title" => $locationEvent->title,
    "date" => $locationEvent->date,
    "created" => $locationEvent->created,
    "modified" => $locationEvent->modified,
    "status" => $locationEvent->status,
    "location_id" => $locationEvent->location_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($locationEvent_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read location event."
        )
    );
}