<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Language.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init language object
$language = new Language($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$language->language_id = $data->language_id;
$language->lang_name = $data->lang_name;

if(check_auth()){
    // Create language
    if ($language->update()) {
        echo json_encode(
            array("message" => "language updated")
        );
    } else {
        echo json_encode(
            array("message" => "language not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update language."
        )
    );
}