<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Item.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init item object
$item = new Item($db);

// Store read method result in variable & count rows
$result = $item->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // item array
        $item_arr = array();
        $item_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
            
            // Each item will look like this
            $item = array(
                'item_id' => $item_id,
                'item_title' => $item_title,
                'item_desc' => $item_desc,
                'item_mere' => $item_mere,
                'item_time' => $item_time,
                'item_visibility' => $item_visibility,  
                'item_user' => $item_user, 
                'item_image' => $item_image, 
                'item_image1' => $item_image1,
                'item_image2' => $item_image2,
                'item_image3' => $item_image3,
                'image_desc' => $image_desc,  
                'image_desc1' => $image_desc1, 
                'image_desc2' => $image_desc2, 
                'image_desc3' => $image_desc3,
                'category_id' => $category_id,
                'report_id' => $report_id     
            );

            // Push to "Data"
            array_push($item_arr["data"], $item);
        }
        // Convert result to JSON
        echo json_encode($item_arr);
    } else {
        // No items returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No items found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read items."
        )
    );
}




