<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Inbox.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init inbox object
$inbox = new Inbox($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$inbox->company_id = $data->company_id;
$inbox->message1 = $data->message1;

if(check_auth()){
    // Create inbox
    if ($inbox->create()) {
        echo json_encode(
            array("message" => "inbox message created")
        );
    } else {
        echo json_encode(
            array("message" => "inbox message not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create inbox message."
        )
    );
}