<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Header.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init header object
$header = new Header($db);
$header->head_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$header->read_single();

// header array
$header_arr = array(
    "head_id" => $header->head_id,
    "head_rep_title" => $header->head_rep_title,
    "head_comp_label" => $header->head_comp_label,
    "head_comp_title" => $header->head_comp_title,
    "head_proj_label" => $header->head_proj_label,
    "head_proj_title" => $header->head_proj_title,
    "head_loc_label" => $header->head_loc_label,
    "head_loc_title" => $header->head_loc_title,
    "head_logo" => $header ->head_logo,
    "location_id" => $header->location_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($header_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read header."
        )
    );
}