<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Gallery.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init gallery object
$gallery = new Gallery($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$gallery->gallery_id = $data->gallery_id;

if(check_auth()){
    // Create a file
    if ($gallery->delete()) {
        echo json_encode(
            array("message" => "gallery file deleted")
        );
    } else {
        echo json_encode(
            array("message" => "gallery file not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete gallery file."
        )
    );
}