<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/File.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init file object
$file = new File($db);

// Store read method result in variable & count rows
$result = $file->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // file array
        $file_arr = array();
        $file_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each file will look like this
            $file = array(
                'file_id' => $file_id,
                'file_name' => $file_name,
                'company_id' => $company_id,
                'location_id' => $location_id,
                'user_id' => $user_id       
            );

            // Push to "Data"
            array_push($file_arr["data"], $file);
        }
        // Convert result to JSON
        echo json_encode($file_arr);
    } else {
        // No files returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No files found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read files."
        )
    );
}




