<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/File.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init file object
$file = new File($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$file->file_name = $data->file_name;
$file->company_id = $data->company_id;
$file->location_id = $data->location_id;
$file->user_id = $data->user_id;

if(check_auth()){
    // Create file
    if ($file->create()) {
        echo json_encode(
            array("message" => "file created")
        );
    } else {
        echo json_encode(
            array("message" => "file not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create file."
        )
    );
}