<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/DriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init driversLicence object
$driversLicence = new DriversLicence($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$driversLicence->drivers_licence_id = $data->drivers_licence_id;
$driversLicence->dl_title = $data->dl_title;

if(check_auth()){
    // Create a driversLicence
    if ($driversLicence->update()) {
        echo json_encode(
            array("message" => "Drivers Licence updated")
        );
    } else {
        echo json_encode(
            array("message" => "Drivers Licence not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update drivers licence."
        )
    );
}
