<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";
include_once "../../models/DriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init driversLicence object
$driversLicence = new DriversLicence($db);

// Store read method result in variable & count rows
$result = $driversLicence->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // driversLicence array
        $driversLicence_arr = array();
        $driversLicence_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each driversLicence will look like this
            $driversLicence = array(
                'drivers_licence_id' => $drivers_licence_id,
                'dl_title' => $dl_title      
            );

            // Push to "Data"
            array_push($driversLicence_arr["data"], $driversLicence);
        }
        // Convert result to JSON
        echo json_encode($driversLicence_arr);
    } else {
        // No driversLicences returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No drivers licences found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read drivers licences."
        )
    );
}





