<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyRegion.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyRegion object
$companyRegion = new CompanyRegion($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->company_id) && !empty($data->region_id) && !empty($data->new_region_id)) {
    
    $companyRegion->company_id = $data->company_id;
    $companyRegion->region_id = $data->region_id;
    $companyRegion->new_region_id = $data->new_region_id;

    if(check_auth()){

        if ($companyRegion->update()) {
            echo json_encode(
                array("message" => "Company region updated")
            );
        } else {
            echo json_encode(
                array("message" => "Company region not updated")
            );
        }
    } else {
        echo json_encode(
            array(
                "status" => 401,
                "message" => "Not authorized to update company region."
            )
        );
    }
} else {
    echo json_encode(
        array("message" => "Missing required data")
    );
}

?>
