<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyRegion.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyRegion object
$companyRegion = new CompanyRegion($db);

// Store read method result in variable & count rows
$result = $companyRegion->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // companyRegion array
        $companyRegion_arr = array();
        $companyRegion_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each companyRegion will look like this
            $companyRegion = array(
                'company_id' => $company_id,
                'region_id' => $region_id 
            );

            // Push to "Data"
            array_push($companyRegion_arr["data"], $companyRegion);
        }
        // Convert result to JSON
        echo json_encode($companyRegion_arr);
    } else {
        // No companyRegion returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No company regions found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company regions."
        )
    );
}




