<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();
// Disable foreign key checks
$db->query("SET foreign_key_checks = 0");

// Init company place object
$companyPlace = new CompanyPlace($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$companyPlace->company_place_id = $data->company_place_id;
$companyPlace->company_place_name = $data->company_place_name;
$companyPlace->company_place_address = $data->company_place_address;
$companyPlace->company_place_city = $data->company_place_city;
// $companyPlace->admin_id = $data->admin_id;
//$companyPlace->company_id = $data->company_id;

if(!check_auth()){
    if ($companyPlace->update()) {
        echo json_encode(array("message" => "company place updated"));
    } else {
        //header("HTTP/1.1 400");
        echo json_encode(array("message" => "company place not updated"));
    }
} else {
    
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update company place."
        )
    );
}