<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyPlace object
$companyPlace = new CompanyPlace($db);
$companyPlace->company_place_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$companyPlace->read_single();


// companyPlace array
$companyPlace_arr = array(
    "company_place_id" => $companyPlace->company_place_id,
    "company_place_name" => $companyPlace->company_place_name,
    "company_place_address" => $companyPlace->company_place_address,
    "company_google_maps_link" => $companyPlace->company_google_maps_link,
    "company_place_city" => $companyPlace->company_place_city,
    "admin_id" => $companyPlace->admin_id,
    "company_id" => $companyPlace->company_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($companyPlace_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company place."
        )
    );
}