<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$companyPlace = new CompanyPlace($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$companyPlace->company_place_id = $data->company_place_id;

if(!check_auth()){
    // Create company place
    if ($companyPlace->delete()) {
        echo json_encode(
            array("message" => "company place deleted")
        );
    } else {
        echo json_encode(
            array("message" => "company place not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete company place."
        )
    );
}