<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyEvent.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init object
$companyEvent = new CompanyEvent($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$companyEvent->company_events_id = $data->company_events_id;
$companyEvent->title = $data->title;
$companyEvent->date = $data->date;
$companyEvent->created = $data->created;
$companyEvent->modified = $data->modified;
$companyEvent->status = $data->status;
$companyEvent->company_id = $data->company_id;

if(check_auth()){
    // Create
    if ($companyEvent->update()) {
        echo json_encode(
            array("message" => "Company Event updated")
        );
    } else {
        echo json_encode(
            array("message" => "Company Event not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update company event."
        )
    );
}
