<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyEvent.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyEvent object
$companyEvent = new CompanyEvent($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$companyEvent->title = $data->title;
$companyEvent->date = $data->date;
$companyEvent->company_id = $data->company_id;

if(!check_auth()){
    // Create a companyEvent
    if ($companyEvent->create()) {
        echo json_encode(
            array("message" => "company event created")
        );
    } else {
        echo json_encode(
            array("message" => "company event not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create company event."
        )
    );
}
