<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyAdmin.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyAdmin object
$companyAdmin = new CompanyAdmin($db);
$companyAdmin->company_id = isset($_GET["company_id"]) ? $_GET["company_id"] : die();
$companyAdmin->admin_id = isset($_GET["admin_id"]) ? $_GET["admin_id"] : die();

$companyAdmin->read_single($companyAdmin->company_id, $companyAdmin->admin_id);

// companyAdmin array
$companyAdmin_arr = array(
    "company_id" => $companyAdmin->company_id,
    "admin_id" => $companyAdmin->admin_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($companyAdmin_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company admin."
        )
    );
}
