<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyActivity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyActivity object
$companyActivity = new CompanyActivity($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->company_id) && !empty($data->act_id) && !empty($data->new_act_id)) {
    
    $companyActivity->company_id = $data->company_id;
    $companyActivity->act_id = $data->act_id;
    $companyActivity->new_act_id = $data->new_act_id;

    if(check_auth()){
        if ($companyActivity->update()) {
            echo json_encode(
                array("message" => "Company Activity updated")
            );
        } else {
            echo json_encode(
                array("message" => "Company Activity not updated")
            );
        }
    } else {
        echo json_encode(
            array(
                "status" => 401,
                "message" => "Not authorized to update company activity."
            )
        );
    }
        
} else {
    echo json_encode(
        array("message" => "Missing required data")
    );
}

?>
