<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/CompanyActivity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init companyActivity object
$companyActivity = new CompanyActivity($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$companyActivity->company_id = $data->company_id;
$companyActivity->act_id = $data->act_id;

if(check_auth()){
    // Delete companyActivity
    if ($companyActivity->delete()) {
        echo json_encode(
            array("message" => "Company Activity deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Company Activity not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete company activity."
        )
    );
}

