<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Company.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init company object
$company = new Company($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$company->company_id = $data->company_id;
$company->company_name = $data->company_name;
$company->company_email = $data->company_email;
$company->company_logo = $data->company_logo;
$company->company_subscription = $data->company_subscription;
$company->company_current_accounts = $data->company_current_accounts;
$company->company_max_accounts = $data->company_max_accounts;

if(check_auth()){
    // Create a company
    if ($company->update()) {
        echo json_encode(
            array("message" => "Company updated")
        );
    } else {
        echo json_encode(
            array("message" => "Company not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update company."
        )
    );
}
