<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Company.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init company object
$company = new Company($db);
$company->company_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$company->read_single();


// company array
$company_arr = array(
    "company_id" => $company->company_id,
    "company_name" => $company->company_name,
    "company_logo" => $company->company_logo,
    "company_email" => $company->company_email,
    "company_subscription" => $company->company_subscription,
    "company_current_accounts" => $company->company_current_accounts,
    "company_max_accounts" => $company->company_max_accounts,
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($company_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company."
        )
    );
}
