<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Company.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init Company object
$company = new Company($db);
$parent_id =  isset($_GET["company_id"]) ? $_GET["company_id"] : die();

// Store read method result in variable & count rows
$result = $company->getChildCompanies($parent_id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // Company array
        $company_arr = array();
        $company_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $company = array(
                'company_id' => $company_id,      
                'company_name' => $company_name,      
                'company_logo' => $company_logo
            );

            // Push to "Data"
            array_push($company_arr["data"], $company);
        }
        // Convert result to JSON
        echo json_encode($company_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No companies found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read companies."
        )
    );
}





