<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Company.php";

$database = new Database();
$db = $database->connect();

$company = new Company($db);
$result = $company->read();
$num = $result->rowCount();

$companies_arr = array();

if(!check_auth()){
    if ($num > 0) {
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $company_item = array(
                "company_id" => $company_id,
                "logo" => $company_logo,
                "company_name" => $company_name,
                "accounts" => array(),
                "locations" => array(),
                "archived_locations" => array(),
                "users" => array(),
                "archived_users" => array(),
                "maxLocations" => 5,
                "maxUsers" => 10
            );

            // child companies for the current parent company
            $childCompanies = $company->getChildCompanies($company_id);

            foreach ($childCompanies as $childCompany) {
                $childCompanyItem = array(
                    "company_id" => $childCompany['company_id'],
                    "logo" =>  $childCompany['company_logo'],
                    "company_name" => $childCompany['company_name'],
                    "locations" => array(),
                    "archived_locations" => array(),
                    "users" => array(),
                    "archived_users" => array(),
                    "maxLocations" => 5,
                    "maxUsers" => 10
                );

                // locations for the current child company
                $childCompanyItem['locations'] = $company->getCompanyLocations($childCompany['company_id']);

                // users for the current child company
                $childCompanyItem['users'] = $company->getActiveUsers($childCompany['company_id']);

                // archived users for the current child company
                $childCompanyItem['archived_users'] = $company->getArchivedUsers($childCompany['company_id']);

                // archived locations for the current child company
                $childCompanyItem['archived_locations'] = $company -> getArchivedLocations($childCompany['company_id']);

                $company_item['accounts'][] = $childCompanyItem;
            }

            // locations for the current parent company
            $company_item['locations'] = $company->getCompanyLocations($company_id);

            // users for the current parent company
            $company_item['users'] = $company->getActiveUsers($company_id);

            // archived users for the current parent company
            $company_item['archived_users'] = $company->getArchivedUsers($company_id);

            // archived locations for the current parent company
            $company_item['archived_locations'] = $company -> getArchivedLocations($company_id);


            $companies_arr[] = $company_item;
        }

        echo json_encode($companies_arr);
    } else {
        echo json_encode(array("message" => "No companies found"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read companies."
        )
    );
}

?>