<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Company.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init company object
$company = new Company($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$company->company_id = $data->company_id;

if(check_auth()){
    // Create a company
    if ($company->delete()) {
        echo json_encode(
            array("message" => "Company deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Company not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete company."
        )
    );
}
