<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Comment.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init comment object
$comment = new Comment($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$comment->comment_text = $data->comment_text;
$comment->comment_image = $data->comment_image;
$comment->comment_user = $data->comment_user;
$comment->comment_date = $data->comment_date;
$comment->comment_time = $data->comment_time;
$comment->item_id = $data->item_id;

if(check_auth()){
    // Create comment
    if ($comment->create()) {
        echo json_encode(
            array("message" => "Comment created")
        );
    } else {
        echo json_encode(
            array("message" => "Comment not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create comment."
        )
    );
}
