<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/City.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init city object
$city = new City($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$city->city_id = $data->city_id;

if(check_auth()){
    // Create a city
    if ($city->delete()) {
        echo json_encode(
            array("message" => "city deleted")
        );
    } else {
        echo json_encode(
            array("message" => "city not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete city."
        )
    );
}