<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/ChatProfile.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init address book object
$chat_profile = new ChatProfile($db);

// GET compay_id from URL 
$id =  isset($_GET["id"]) ? $_GET["id"] : die();
// Store read method result in variable & count rows
$result = $chat_profile->read($id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // address book array
        $chat_profile_arr = array();
        $chat_profile_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each address book will look like this
            $chat_profile = array(
                'id' => $profile_id,
                'name' => $profile_name,
                'user_id' => $user_id,
                'company_id' => $company_id
            );

            // Push to "Data"
            array_push($chat_profile_arr["data"], $chat_profile);
        }
        // Convert result to JSON
        echo json_encode($chat_profile_arr);
    } else {
        // No address book returned from query
         header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No profiles found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read profiles."
        )
    );
}




