<?php

$_SESSION['location_id'] = 7;

// Retrieve user information from the session
$loggedInUserId = $_SESSION['user_id'] ?? "";
$loggedInCompanyId = $_SESSION['company_id'] ?? "";
$loggedInLocationId = $_SESSION['location_id'] ?? "";

// Rest of your script remains the same
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/ChatMessage.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init chatMessage object
$chatMessage = new ChatMessage($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

// // Check if properties exist before assigning them
// $chatMessage->user_id = isset($data->user_id) ? $data->user_id : null;
$chatMessage->content = $data->content;
// $chatMessage->location_id = isset($data->location_id) ? $data->location_id : null;
// $chatMessage->company_id = isset($data->company_id) ? $data->company_id : null;

$chatMessage->user_id = $loggedInUserId;
$chatMessage->location_id = $loggedInLocationId;
$chatMessage->company_id = $loggedInCompanyId;

if (!check_auth()) {
    // Create chatMessage
    if ($chatMessage->create()) {
        echo json_encode(
            array("message" => "chat message created")
        );
    } else {
        echo json_encode(
            array("message" => "chat message not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create chat message."
        )
    );
}

?>
