<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Category.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init category object
$category = new Category($db);
$category->cat_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$category->read_single();


// category array
$category_arr = array(
   "category_id" =>$category->cat_id,
   "category_name" =>$category->cat_name,
);

if(check_auth()){
   // Convert resutl to JSON
   print_r(json_encode($category_arr));
} else {
   echo json_encode(
       array(
           "status" => 401,
           "message" => "Not authorized to read category."
       )
   );
}