<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Category.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init category object
$category = new Category($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$category->cat_name = $data->cat_name;
$category->cat_char = $data->cat_char;
$category->cat_color = $data->cat_color;
$category->location_id = $data->location_id;

if(check_auth()){
    // Create a category
    if ($category->create()) {
        echo json_encode(
            array("message" => "category created")
        );
    } else {
        echo json_encode(
            array("message" => "category not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create category."
        )
    );
}