<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Admin.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin object
$admin = new Admin($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$admin->admin_id = $data->admin_id;
$admin->user_id = $data->user_id;
$admin->admin_role = $data->admin_role;

if(check_auth()){
    // Create admin
    if ($admin->update()) {
        echo json_encode(
            array("message" => "Admin updated")
        );
    } else {
        echo json_encode(
            array("message" => "Admin not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update admin."
        )
    );
}