<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Admin.php";


// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin object
$admin = new Admin($db);
$admin->admin_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$admin->read_single();


// admin array
$admin_arr = array(
    "admin_id" => $admin->admin_id,
    "user_id" => $admin->user_id,
    "admin_role" => $admin->admin_role
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($admin_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admin."
        )
    );
}