<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Admin.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin object
$admin = new Admin($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$admin->user_id = $data->user_id;
$admin->admin_role = $data->admin_role;

if(check_auth()){
    // Create admin
    if ($admin->create()) {
        echo json_encode(
            array("message" => "Admin created")
        );
    } else {
        echo json_encode(
            array("message" => "Admin not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create admin."
        )
    );
}