<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AdminNote.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin object
$adminNote = new AdminNote($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$adminNote->note_id = $data->note_id;
$adminNote->content = $data->content;
$adminNote->admin_id = $data->admin_id;

if(check_auth()){
    if ($adminNote->update()) {
        echo json_encode(array("message" => "Admin note updated"));
    } else {
        echo json_encode(array("message" => "Admin note not updated"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update admin note."
        )
    );
}
