<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AdminNote.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init adminNote object
$adminNote = new AdminNote($db);
$adminNote->note_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$adminNote->read_single();


// adminNote array
$adminNote_arr = array(
    "note_id" => $adminNote->note_id,
    "content" => $adminNote->content,
    "created_at" => $adminNote->created_at,
    "admin_id" => $adminNote->admin_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($adminNote_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admin note."
        )
    );
}