<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/AdminNote.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init adminNote object
$adminNote = new adminNote($db);

// Store read method result in variable & count rows
$result = $adminNote->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // adminNote array
        $adminNote_arr = array();
        $adminNote_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each adminNote will look like this
            $adminNote = array(
                'note_id' => $note_id, 
                'content' => $content, 
                'created_at' => $created_at, 
                'admin_id' => $admin_id         
            );

            // Push to "Data"
            array_push($adminNote_arr["data"], $adminNote);
        }
        // Convert result to JSON
        echo json_encode($adminNote_arr);
    } else {
        // No admin notes returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No admin notes found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admin notes."
        )
    );
}




