<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../../config/Database.php";
include_once "../../../models/Company.php";
include_once "../../../config/authorization.php";
include_once "../../../config/functions.php";

$database = new Database();
$db = $database->connect();

$company = new Company($db); 

$company_id = $_GET['company_id'];

$result = $company->getArchivedUsers($company_id);
$num = $result->rowCount();

if(check_auth()){
    if($num > 0){

        $company_arr = array();
        $company_arr['data'] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);
        
            $company = array(
                'user_id' => $user_id,
                'user_name' => $user_name
            );
        
            array_push($company_arr['data'], $company);
        }    

        echo json_encode($company_arr);

    } else {
        echo json_encode (
            array(
                "message" => "No archived users for companies found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read company archived users."
        )
    );
}