<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AddressBook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init address book object
$addressBook = new AddressBook($db);
$addressBook->address_book_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$addressBook->read_single();


// Address book array
$addressBook_arr = array(
    "address_book_id" => $addressBook->address_book_id,
    "ab_name" => $addressBook->ab_name,
    "ab_email" => $addressBook->ab_email,
    "user_id" => $addressBook->user_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($addressBook_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read adress book contact."
        )
    );
}